package com.burhanstore.neonbubblequest.act

import android.app.Activity
import android.content.ClipData
import android.content.ClipboardManager
import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import com.burhanstore.neonbubblequest.Utils.DialogManager
import com.burhanstore.neonbubblequest.Utils.anim.setClick
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.burhanstore.neonbubblequest.databinding.ActivityInviteBinding


class InviteActivity : AppCompatActivity() {


    private lateinit var binding: ActivityInviteBinding
    private lateinit var activity: Activity

    private lateinit var manager: UserManager

    private var uid: String = ""


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityInviteBinding.inflate(layoutInflater)
        setContentView(binding.root)
        activity = this

        DialogManager.initDialog(activity)
        manager = UserManager.getInstance(activity)
        uid = manager.getUser()?.u_id ?: ""



        binding.imageView2.setClick {
            finish()
        }

        val referCode = manager.getUser()?.refer

        binding.referCode.text = "Refer Code : " + referCode

        binding.referCopyBtn.setClick {
            val clipboard = getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager
            val clip = ClipData.newPlainText("Copied Text", referCode)
            clipboard.setPrimaryClip(clip)
            Toast.makeText(this, "Copied to clipboard!", Toast.LENGTH_SHORT).show()
        }

        binding.whatsappBtn.setClick {
            val packageName = applicationContext.packageName
            val appLink = "https://play.google.com/store/apps/details?id=$packageName"

            val shareText = """
        🎁 Hey there! 
        I'm inviting you to try *ZodRewards* — an amazing rewards app where you can earn daily bonuses, redeem gift cards, and much more! 💸

        👉 Use my referral code: *$referCode*
        Download now and start earning instantly:
        $appLink

        🚀 Let's earn together!
    """.trimIndent()

            val intent = Intent(Intent.ACTION_SEND)
            intent.type = "text/plain"
            intent.setPackage("com.whatsapp") // Only WhatsApp
            intent.putExtra(Intent.EXTRA_TEXT, shareText)

            try {
                startActivity(intent)
            } catch (e: Exception) {
                Toast.makeText(this, "WhatsApp not installed!", Toast.LENGTH_SHORT).show()
            }
        }

        binding.shareBtn.setClick {
            val packageName = applicationContext.packageName
            val appLink = "https://play.google.com/store/apps/details?id=$packageName"

            val shareText = """
        🎁 Hey there! 
        I'm inviting you to try *ZodRewards* — an amazing rewards app where you can earn daily bonuses, redeem gift cards, and much more! 💸

        👉 Use my referral code: *$referCode*
        Download now and start earning instantly:
        $appLink

        🚀 Let's earn together!
    """.trimIndent()

            val intent = Intent(Intent.ACTION_SEND)
            intent.type = "text/plain"
            intent.putExtra(Intent.EXTRA_TEXT, shareText)

            // 📱 Show system share chooser (all apps that support sharing)
            val chooser = Intent.createChooser(intent, "Share with friends via...")
            startActivity(chooser)
        }

        binding.facebookBtn.setClick {
            val packageName = applicationContext.packageName
            val appLink = "https://play.google.com/store/apps/details?id=$packageName"

            val shareText = """
        🎁 Join me on *ZodRewards*!
        Earn daily rewards, redeem gift cards & have fun 💸
        
        👉 Use my referral code: *$referCode*
        Download now: $appLink
    """.trimIndent()

            val intent = Intent(Intent.ACTION_SEND)
            intent.type = "text/plain"
            intent.setPackage("com.facebook.katana") // Facebook app package
            intent.putExtra(Intent.EXTRA_TEXT, shareText)

            try {
                startActivity(intent)
            } catch (e: Exception) {
                Toast.makeText(this, "Facebook app not installed!", Toast.LENGTH_SHORT).show()
            }
        }



    }


}